
#ifdef ESP32
  #include <WiFi.h>
  #include <HTTPClient.h>
#else
  #include <ESP8266WiFi.h>
  #include <ESP8266HTTPClient.h>
  #include <WiFiClient.h>
#endif
 
#include <Wire.h>
#include <Adafruit_Sensor.h>
#include "Adafruit_VL53L0X.h"
#include <OneWire.h>
#include <DallasTemperature.h>

// network credentials
const char* ssid     = "Vodafone-F7AA27";
const char* password = "jVsXtCB93a";
 
// Domain name and URL path or IP address with path
const char* serverName = "https://emicompany.com.mk/server/post-esp-data.php";
 
// API Key value compatible with the PHP code  
String apiKeyValue = "tPmAT5Ab3j7F9";

// TIME-OF-FLIGHT SENSORS
#define LOX1_ADDRESS 0x30
#define LOX2_ADDRESS 0x31
 
#define SHT_LOX1 17
#define SHT_LOX2 18
 
Adafruit_VL53L0X lox1 = Adafruit_VL53L0X();
Adafruit_VL53L0X lox2 = Adafruit_VL53L0X();
 
VL53L0X_RangingMeasurementData_t measure1;
VL53L0X_RangingMeasurementData_t measure2;

int x = 0;
int y = 0;
int s1 = 0;
int s2 = 0;
int sensor1 = 0;
int sensor2 = 0;
int value3 = 0;
int value4 = 0;

void setID() {
  // all reset
  digitalWrite(SHT_LOX1, LOW);    
  digitalWrite(SHT_LOX2, LOW);
  delay(10);
  // all unreset
  digitalWrite(SHT_LOX1, HIGH);
  digitalWrite(SHT_LOX2, HIGH);
  delay(10);
  // activating LOX1 and reseting LOX2
  digitalWrite(SHT_LOX1, HIGH);
  digitalWrite(SHT_LOX2, LOW);
  // initing LOX1
  if(!lox1.begin(LOX1_ADDRESS)) {
    Serial.println(F("Failed to boot first VL53L0X"));
    while(1);
  }
  delay(10);
  // activating LOX2
  digitalWrite(SHT_LOX2, HIGH);
  delay(10);
  //initing LOX2
  if(!lox2.begin(LOX2_ADDRESS)) {
    Serial.println(F("Failed to boot second VL53L0X"));
    while(1);
  }
}

void read_dual_sensors() {
  lox1.rangingTest(&measure1, false);
  lox2.rangingTest(&measure2, false);
  
  // sensor one reading
  Serial.print(F("1: "));
  if(measure1.RangeMilliMeter <= 70) {
    sensor1 = 1;
    s1 = 1;
    Serial.print(sensor1);
  } else {
    s1 = 0;
    Serial.print(sensor1);
  }
  Serial.print(F(" "));

  // sensor two reading
  Serial.print(F("2: "));
  if(measure2.RangeMilliMeter <= 70){
    sensor2 = 1;
    s2 = 1;
    Serial.print(sensor2);
  } else {
    s2 = 0;
    Serial.print(sensor2);
  }
    
  if(sensor1 == 0 && sensor2 == 1) {
    x = 1;
    y = 0;
  }
  if(sensor1 == 1 && sensor2 == 0) {
    y = 1;
    x = 0;
  }
  if(sensor1 == 1 && sensor2 == 1) {
    if(y == 1) {
      if(s2 == 0) {
          sensor1 = 0;
          s1 = 0;
          y = 0;
          x = 0;
          sensor2 = 0;
          s2 = 0;
          value3 = 1;      
      }
    }
    if(x == 1) {
      if(s1 == 0) {
          sensor1 = 0;
          s1 = 0;
          x = 0;
          y = 0;
          sensor2 = 0;
          s2 = 0;
          value4 = 1;          
      }
    }
  } 
  Serial.println(""); 
  Serial.print("X = ");
  Serial.print(x); 
  Serial.print(", Y = ");
  Serial.print(y); 
  Serial.print(", S1 = ");
  Serial.print(s1); 
  Serial.print(", S2 = ");
  Serial.print(s2); 
  Serial.println(""); 
  Serial.println(""); 
}

// TEMPERATURE SENSOR
const int oneWireBus = 26;     
OneWire oneWire(oneWireBus);
DallasTemperature sensors(&oneWire);
String temperatureC = "";

// HUMIDITY SENSOR
const int moisturePin = 34;
int moisturePercentage;  


void setup() {
  sensors.begin();
  Serial.begin(115200);
  // connect to Wi-Fi
  WiFi.begin(ssid, password);
  Serial.println("Connecting");
  while(WiFi.status() != WL_CONNECTED) { 
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to WiFi network with IP Address: ");
  Serial.println(WiFi.localIP());

  // setting up the tof sensors
  pinMode(SHT_LOX1, OUTPUT);
  pinMode(SHT_LOX2, OUTPUT);
  Serial.println(F("Shutdown pins inited..."));
  
  digitalWrite(SHT_LOX1, LOW);
  digitalWrite(SHT_LOX2, LOW);
  Serial.println(F("Both in reset mode...(pins are low)"));
  Serial.println(F("Starting..."));
  setID();
}
 
void loop() {
  // check WiFi connection status
  if(WiFi.status()== WL_CONNECTED){
    HTTPClient http;
    http.begin(serverName);
    // content-type header
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");

    sensors.requestTemperatures();
    moisturePercentage = (analogRead(moisturePin) / 4095.00) * 100.00;
    value3 = 0; // resetting value3 - worms inside
    value4 = 0; // resetting value4 - worms outside
    read_dual_sensors();

    // HTTP POST request data
    String httpRequestData = "api_key=" + apiKeyValue + "&sensor=" + "Temperature"
                          + "&location=" + "ISEP" + "&value1=" + String(sensors.getTempCByIndex(0))
                          + "&value2=" + String(moisturePercentage) + "&value3=" + String(value3) + "&value4=" + String(value4);
                              
    Serial.print("httpRequestData: ");
    Serial.println(httpRequestData);
 
    // send HTTP POST request
    int httpResponseCode = http.POST(httpRequestData);
       
    if (httpResponseCode>0) {
      Serial.print("HTTP Response code: ");
      Serial.println(httpResponseCode);
    } else {
      Serial.print("Error code: ");
      Serial.println(httpResponseCode);
    }
    // free resources
    http.end();
  }
  else {
    Serial.println("WiFi Disconnected");
  }

  delay(5000);  
}
